/*
 * Decompiled with CFR 0.152.
 */
package org.mtk.arcade.billboard;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.mtk.arcade.billboard.BillboardEditor;
import org.mtk.arcade.billboard.BillboardLayer;
import org.mtk.arcade.billboard.BoardFactory;
import org.mtk.arcade.billboard.ColorMenu;
import org.mtk.util.BitmapBuffer;

public class BillboardApp
extends JFrame {
    JOptionPane optPane;
    JTabbedPane tabbedPane;
    final BillboardApp billboard;
    ColorMenu cm;
    JDialog jd;
    JButton colorButton;
    ColorBrick cb;
    final String romloc;
    BitmapBuffer s1;
    public static final int DEFAULT_MAG = 4;
    BillboardEditor primaryEdit;
    BillboardEditor secondaryEdit;
    BillboardEditor shrunkPrimaryEdit;
    BillboardEditor shrunkSecondaryEdit;
    BillboardLayer layer;
    boolean mini;
    int tabIndex;
    String board;

    public BillboardApp(String romloc, String board, String size) throws IOException {
        super("Billboard - Pole Position Billboard Editor");
        this.romloc = romloc;
        this.board = board;
        if ("mini".equals(size)) {
            this.mini = true;
        }
        this.setSize(600, 300);
        this.billboard = this;
        this.init();
    }

    public void init() throws IOException {
        this.setDefaultCloseOperation(3);
        this.optPane = new JOptionPane();
        this.optPane.setWantsInput(true);
        Container c = this.getContentPane();
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        JMenuItem openItem = new JMenuItem("Import GIF");
        OpenAction open = new OpenAction("Import GIF", null, null, 'O');
        openItem.addActionListener(open);
        fileMenu.add(openItem);
        fileMenu.addSeparator();
        JMenuItem saveItem = new JMenuItem("Save ROMS");
        SaveAction save = new SaveAction("Save ROMS", null, null, 'S');
        saveItem.addActionListener(save);
        saveItem.setEnabled(true);
        JMenuItem saveGifItem = new JMenuItem("Save GIF");
        SaveGifAction saveGif = new SaveGifAction("Save GIF", null, null, 'S');
        saveGifItem.addActionListener(saveGif);
        saveGifItem.setEnabled(true);
        fileMenu.add(saveItem);
        fileMenu.addSeparator();
        fileMenu.add(saveGifItem);
        fileMenu.addSeparator();
        fileMenu.add(new ExitAction("Exit", null, null));
        menuBar.add(fileMenu);
        this.setJMenuBar(menuBar);
        this.layer = BoardFactory.getLayer(this.board, this.romloc, this.mini);
        this.primaryEdit = new BillboardEditor(this.layer, 0, 4, false, true);
        this.secondaryEdit = new BillboardEditor(this.layer, 1, 4, false, true);
        if (!this.mini) {
            this.shrunkPrimaryEdit = new BillboardEditor(this.layer, 0, 4, true, false);
            this.shrunkSecondaryEdit = new BillboardEditor(this.layer, 1, 4, true, false);
        }
        JToolBar toolBar = new JToolBar();
        JButton incMag = new JButton("+");
        JButton decMag = new JButton("-");
        JButton clearButton = new JButton("CLEAR");
        toolBar.add(incMag);
        toolBar.add(decMag);
        this.cm = new ColorMenu(this.primaryEdit, this.secondaryEdit);
        this.primaryEdit.setColor(this.cm.getColor());
        this.jd = new JDialog(this.billboard, "Colors", true);
        this.jd.setContentPane(this.cm);
        this.jd.setSize(this.cm.getPreferredSize());
        this.jd.setLocation(50, 100);
        this.cm.addPropertyChangeListener("click", e -> {
            ColorMenu colorMenu = (ColorMenu)e.getSource();
            this.cb.setColor(colorMenu.getColor());
            if (this.tabIndex % 2 == 0) {
                this.primaryEdit.setColor(this.cb.getColor());
            } else {
                this.secondaryEdit.setColor(this.cb.getColor());
            }
            this.jd.setVisible(false);
        });
        this.colorButton = new JButton();
        this.cb = new ColorBrick();
        this.cb.setColor(this.cm.getColor());
        this.colorButton.add(this.cb);
        this.colorButton.addActionListener(ae -> this.jd.setVisible(true));
        toolBar.add(this.colorButton);
        clearButton.addActionListener(e -> {
            if (this.tabIndex % 2 == 0) {
                this.primaryEdit.clear();
            } else {
                this.secondaryEdit.clear();
            }
        });
        toolBar.add(clearButton);
        incMag.addActionListener(e -> {
            this.primaryEdit.increaseMagnification();
            this.secondaryEdit.increaseMagnification();
        });
        decMag.addActionListener(e -> {
            this.primaryEdit.decreaseMagnification();
            this.secondaryEdit.decreaseMagnification();
        });
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab("Primary", this.primaryEdit);
        this.tabbedPane.addTab("Secondary", this.secondaryEdit);
        if (!this.mini) {
            this.tabbedPane.addTab("ShrunkenPrimary", this.shrunkPrimaryEdit);
            this.tabbedPane.addTab("ShrunkenSecondary", this.shrunkSecondaryEdit);
        }
        this.tabbedPane.setVisible(true);
        this.tabbedPane.addChangeListener(e -> {
            this.tabIndex = this.tabbedPane.getSelectedIndex();
            this.cm.update(this.tabIndex % 2);
            this.cb.setColor(this.cm.getColor());
            this.primaryEdit.setColor(this.cm.getColor());
            this.secondaryEdit.setColor(this.cm.getColor());
        });
        this.setPreferredSize(new Dimension(600, 400));
        this.add((Component)toolBar, "North");
        this.add((Component)this.tabbedPane, "Center");
        this.revalidate();
        this.repaint();
        this.pack();
        this.setVisible(true);
    }

    public static void main(String[] args) throws IOException {
        Map<String, String> inputs = BillboardApp.parseArgs(args);
        String romloc = inputs.get("--romloc");
        String type = inputs.get("--editor");
        String size = inputs.get("--mini");
        BillboardApp billboard = new BillboardApp(romloc, type, size);
        billboard.setVisible(true);
    }

    private static Map<String, String> parseArgs(String[] args) {
        HashMap<String, String> inputs = new HashMap<String, String>();
        int n = args.length;
        block11: for (int i = 0; i < n; ++i) {
            switch (args[i]) {
                case "--romloc": 
                case "--editor": {
                    if (++i < n) {
                        inputs.put(args[i - 1], args[i]);
                        continue block11;
                    }
                    System.out.println(BillboardApp.usage());
                    System.exit(0);
                    continue block11;
                }
                case "--version": {
                    System.out.println(BillboardApp.version());
                    System.exit(0);
                    continue block11;
                }
                case "--mini": {
                    inputs.put("--mini", "mini");
                    continue block11;
                }
                default: {
                    System.out.println(BillboardApp.usage());
                    System.exit(0);
                }
            }
        }
        for (String required : new String[]{"--romloc", "--editor"}) {
            if (inputs.containsKey(required)) continue;
            System.out.println(BillboardApp.usage());
            System.exit(0);
        }
        return inputs;
    }

    public static String version() {
        String version;
        Class<BillboardApp> clazz = BillboardApp.class;
        String className = clazz.getSimpleName() + ".class";
        String classPath = clazz.getResource(className).toString();
        if (!classPath.startsWith("jar")) {
            String relativePath = clazz.getName().replace('.', File.separatorChar) + ".class";
            String classFolder = classPath.substring(0, classPath.length() - relativePath.length() - 1);
            String manifestPath = classFolder + "/META-INF/MANIFEST.MF";
            version = BillboardApp.readVersionFrom(manifestPath);
        } else {
            String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
            version = BillboardApp.readVersionFrom(manifestPath);
        }
        return version;
    }

    private static String readVersionFrom(String manifestPath) {
        String version;
        try {
            String implementationVersion;
            Manifest manifest = new Manifest(new URL(manifestPath).openStream());
            Attributes attrs = manifest.getMainAttributes();
            version = implementationVersion = attrs.getValue("Implementation-Version");
        }
        catch (Exception e) {
            version = "Manifest error!";
        }
        return version;
    }

    public static String oldversion() {
        URLClassLoader cl = (URLClassLoader)BillboardApp.class.getClassLoader();
        try {
            URL url = cl.findResource("META-INF/MANIFEST.MF");
            Manifest manifest = new Manifest(url.openStream());
            Attributes a = manifest.getMainAttributes();
            return a.getValue("Implementation-Version");
        }
        catch (IOException E) {
            return "Manifest error";
        }
    }

    private static String usage() {
        StringBuilder sb = new StringBuilder("Usage: billboard [OPTIONS} --romloc <romset location> --editor <digdug|centipede|namco|marboro|martini|pepsi>\n");
        sb.append("OPTIONS:\n");
        sb.append("\t--version: outputs the current executable version.\n");
        sb.append("\t--mini: edit the smaller version of the billboard.");
        return sb.toString();
    }

    class OpenAction
    extends AbstractAction {
        public OpenAction(String text, Icon icon, String description, char accelerator) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fileChooser = new JFileChooser();
            FileNameExtensionFilter filter = new FileNameExtensionFilter("GIF files", "gif");
            fileChooser.setFileFilter(filter);
            int returnValue = fileChooser.showOpenDialog(BillboardApp.this);
            if (returnValue == 0) {
                BufferedImage image;
                File selectedFile = fileChooser.getSelectedFile();
                try {
                    image = ImageIO.read(selectedFile);
                }
                catch (IOException ioException) {
                    JOptionPane.showMessageDialog(BillboardApp.this.billboard, "Unable to open file");
                    return;
                }
                try {
                    if (BillboardApp.this.tabIndex == 0) {
                        BillboardApp.this.primaryEdit.importImage(image);
                    } else {
                        BillboardApp.this.secondaryEdit.importImage(image);
                    }
                }
                catch (IllegalArgumentException ex) {
                    JOptionPane.showMessageDialog(BillboardApp.this.billboard, ex.getMessage());
                }
            }
        }
    }

    class SaveAction
    extends AbstractAction {
        public SaveAction(String text, Icon icon, String description, char accelerator) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                BillboardApp.this.layer.save(BillboardApp.this.romloc);
                JOptionPane.showMessageDialog(BillboardApp.this.billboard, "ROMS saved");
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(BillboardApp.this.billboard, "Could not save: " + ioe.getMessage());
            }
        }
    }

    class SaveGifAction
    extends AbstractAction {
        public SaveGifAction(String text, Icon icon, String description, char accelerator) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle("Save As");
            fileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().toLowerCase().endsWith(".gif");
                }

                @Override
                public String getDescription() {
                    return "Graphics Interchange Format (*.gif)";
                }
            });
            int userSelection = fileChooser.showSaveDialog(BillboardApp.this);
            if (userSelection == 0) {
                File fileToSave = fileChooser.getSelectedFile();
                String filePath = fileToSave.getAbsolutePath();
                if (!filePath.toLowerCase().endsWith(".gif")) {
                    filePath = filePath + ".gif";
                }
                try {
                    BufferedImage image = BillboardApp.this.layer.convertToBufferedImage(BillboardApp.this.tabIndex % 2);
                    ImageIO.write((RenderedImage)image, "GIF", new File(filePath));
                    JOptionPane.showMessageDialog(BillboardApp.this, "Saved Image File");
                }
                catch (IOException ioe) {
                    JOptionPane.showMessageDialog(BillboardApp.this, "Failed to save the image: " + ioe.getMessage());
                }
            }
        }
    }

    static class ExitAction
    extends AbstractAction {
        public ExitAction(String text, Icon icon, String description) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            System.exit(0);
        }
    }

    static class ColorBrick
    extends JPanel {
        protected Color m_c = Color.BLACK;

        ColorBrick() {
            this.setBackground(this.m_c);
        }

        public Color getColor() {
            return this.m_c;
        }

        public void setColor(Color c) {
            this.m_c = c;
            this.setBackground(c);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(15, 15);
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }
}

