/*
 * Decompiled with CFR 0.152.
 */
package org.mtk.arcade.billboard;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.JScrollPane;
import org.mtk.arcade.billboard.BillboardLayer;
import org.mtk.arcade.billboard.BillboardLayerPanel;

public class BillboardEditor
extends JScrollPane
implements MouseListener,
MouseMotionListener {
    private final int MAX_MAG = 10;
    private Color color;
    BillboardLayer billboardLayer;
    BillboardLayerPanel pixelpanel;
    final int layer;

    public BillboardEditor(BillboardLayer billboardLayer, int layer, int magnification, boolean mini, boolean enableEdit) {
        this.init(billboardLayer, layer, magnification, mini);
        this.layer = layer;
        if (enableEdit) {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }
    }

    public void init(BillboardLayer billboardLayer, int layer, int magnification, boolean mini) {
        this.billboardLayer = billboardLayer;
        this.pixelpanel = new BillboardLayerPanel(billboardLayer, layer, magnification, mini);
        this.setViewportView(this.pixelpanel);
        this.setPreferredSize(this.pixelpanel.getSize());
    }

    public void increaseMagnification() {
        int magnification = this.pixelpanel.getMagnification();
        if (magnification == 10) {
            return;
        }
        this.pixelpanel.setMagnification(magnification + 1);
        this.revalidate();
        this.repaint();
    }

    public void decreaseMagnification() {
        int magnification = this.pixelpanel.getMagnification();
        if (magnification == 1) {
            return;
        }
        this.pixelpanel.setMagnification(magnification - 1);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent arg0) {
        int magnification = this.pixelpanel.getMagnification();
        int x = arg0.getX();
        int y = arg0.getY();
        int modx = x / magnification;
        int mody = y / magnification;
        this.billboardLayer.setCoord(modx, mody, this.color, this.layer);
        this.pixelpanel.renderShape();
    }

    @Override
    public void mouseMoved(MouseEvent arg0) {
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
        int x = arg0.getX();
        int y = arg0.getY();
        int magnification = this.pixelpanel.getMagnification();
        int modx = x / magnification;
        int mody = y / magnification;
        int extenty = this.verticalScrollBar.getModel().getValue() / magnification;
        int extentx = this.horizontalScrollBar.getModel().getValue() / magnification;
        int adjustx = modx + extentx;
        int adjusty = mody + extenty;
        this.billboardLayer.setCoord(adjustx, adjusty, this.color, this.layer);
        this.pixelpanel.renderShape();
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color[] getColors() {
        return this.billboardLayer.getColorPalette(this.layer);
    }

    public void clear() {
        this.billboardLayer.clear(this.color, this.layer);
        this.pixelpanel.renderShape();
    }

    public void importImage(BufferedImage image) {
        this.billboardLayer.importImage(image, this.layer);
        this.pixelpanel.renderShape();
    }
}

