/*
 * Decompiled with CFR 0.152.
 */
package org.mtk.arcade.billboard;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;

public abstract class BillboardLayer {
    final Color[][][] color;
    final int h;
    final int w;

    public BillboardLayer(int w, int h) {
        this.color = new Color[w][h][2];
        this.w = w;
        this.h = h;
    }

    public int getLayerHeight() {
        return this.h;
    }

    public int getLayerWidth() {
        return this.w;
    }

    public abstract void setCoord(int var1, int var2, Color var3, int var4);

    public abstract Color getCoord(int var1, int var2, int var3);

    public abstract Color[] getColorPalette(int var1);

    public abstract void save(String var1) throws IOException;

    public void clear(Color c, int layer) {
        for (int x = 0; x < this.w; ++x) {
            for (int y = 0; y < this.h; ++y) {
                this.setCoord(x, y, c, layer);
            }
        }
    }

    public abstract void importImage(BufferedImage var1, int var2);

    public abstract BufferedImage convertToBufferedImage(int var1);
}

