/*
 * Decompiled with CFR 0.152.
 */
package org.mtk.arcade.billboard;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;
import org.mtk.arcade.billboard.BillboardLayer;

public class BillboardLayerPanel
extends JPanel {
    final BillboardLayer billboardLayer;
    int magnification;
    final int layer;
    boolean mini;

    public BillboardLayerPanel(BillboardLayer billboardLayer, int layer, int magnification, boolean mini) {
        this.billboardLayer = billboardLayer;
        Dimension d = this.getDimension();
        this.layer = layer;
        this.mini = mini;
        this.magnification = magnification;
        super.setSize(d);
        this.setPreferredSize(d);
    }

    public Dimension getDimension() {
        return new Dimension(this.billboardLayer.getLayerWidth() * this.magnification, this.billboardLayer.getLayerHeight() * this.magnification);
    }

    public void renderShape() {
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(Color.black);
        g.fillRect(0, 0, this.billboardLayer.getLayerWidth() * this.magnification, this.billboardLayer.getLayerHeight() * this.magnification);
        if (this.mini) {
            for (int y = 0; y < this.billboardLayer.getLayerHeight() / 2; ++y) {
                for (int x = 0; x < this.billboardLayer.getLayerWidth() / 2; ++x) {
                    Color c = this.billboardLayer.getCoord(x * 2 + 1, y * 2 + 1, this.layer);
                    if (c == null) {
                        c = Color.black;
                    }
                    g.setColor(c);
                    g.fillRect(x * this.magnification, y * this.magnification, this.magnification, this.magnification);
                }
            }
        } else {
            for (int y = 0; y < this.billboardLayer.getLayerHeight(); ++y) {
                for (int x = 0; x < this.billboardLayer.getLayerWidth(); ++x) {
                    Color c = this.billboardLayer.getCoord(x, y, this.layer);
                    if (c == null) {
                        c = Color.black;
                    }
                    g.setColor(c);
                    g.fillRect(x * this.magnification, y * this.magnification, this.magnification, this.magnification);
                }
            }
        }
    }

    public void setMagnification(int mag) {
        this.magnification = mag;
        this.setSize(this.getDimension());
        this.renderShape();
    }

    public int getMagnification() {
        return this.magnification;
    }
}

