/*
 * Decompiled with CFR 0.152.
 */
package org.mtk.arcade.billboard;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import org.mtk.arcade.billboard.BillboardEditor;

public class ColorMenu
extends JPanel {
    protected final Border unselectedBorder;
    protected final Border selectedBorder;
    protected final Border activeBorder;
    public Map<Color, ColorPane> panes;
    protected ColorPane selected;
    protected final JPanel panel;
    final ColorPane[] lastColor = new ColorPane[2];
    Color[] layer1;
    Color[] layer2;
    int layer;

    public ColorMenu(BillboardEditor primaryEdit, BillboardEditor secondaryEdit) {
        this.layer1 = primaryEdit.getColors();
        this.layer2 = secondaryEdit.getColors();
        this.unselectedBorder = new CompoundBorder(new MatteBorder(1, 1, 1, 1, this.getBackground()), new BevelBorder(1, Color.white, Color.gray));
        this.selectedBorder = new CompoundBorder(new MatteBorder(2, 2, 2, 2, Color.red), new MatteBorder(1, 1, 1, 1, this.getBackground()));
        this.activeBorder = new CompoundBorder(new MatteBorder(2, 2, 2, 2, Color.blue), new MatteBorder(1, 1, 1, 1, this.getBackground()));
        this.panel = new JPanel();
        this.panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.panel.setLayout(new GridLayout(8, 8));
        this.update(this.layer);
        this.add(this.panel);
    }

    public void update(int layer) {
        this.panel.removeAll();
        this.panes = new HashMap<Color, ColorPane>();
        Color[] colors = layer == 1 ? this.layer2 : this.layer1;
        this.selected = null;
        for (Color color : colors) {
            ColorPane pn = new ColorPane(color);
            this.panel.add(pn);
            this.panes.put(color, pn);
        }
        this.selected = this.lastColor[layer];
        if (this.selected == null) {
            this.lastColor[layer] = this.selected = this.panes.get(colors[0]);
        }
        this.layer = layer;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(150, 185);
    }

    public void setColor(Color c) {
        ColorPane obj = this.panes.get(c);
        if (obj == null) {
            return;
        }
        if (this.selected != null) {
            this.selected.setSelected(false);
        }
        this.selected = obj;
        this.selected.setSelected(true);
        this.lastColor[this.layer] = this.selected;
    }

    public Color getColor() {
        if (this.selected == null) {
            return null;
        }
        return this.selected.getColor();
    }

    public void doSelection() {
        this.firePropertyChange("click", this.selected.getColor(), null);
    }

    class ColorPane
    extends JPanel
    implements MouseListener {
        protected final Color color;
        protected boolean selected;

        public ColorPane(Color c) {
            this.color = c;
            this.setBackground(c);
            this.setBorder(ColorMenu.this.unselectedBorder);
            this.addMouseListener(this);
        }

        public Color getColor() {
            return this.color;
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(15, 15);
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
            if (this.selected) {
                this.setBorder(ColorMenu.this.selectedBorder);
            } else {
                this.setBorder(ColorMenu.this.unselectedBorder);
            }
        }

        public boolean isSelected() {
            return this.selected;
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            ColorMenu.this.setColor(this.color);
            ColorMenu.this.doSelection();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.setBorder(ColorMenu.this.activeBorder);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.setBorder(this.selected ? ColorMenu.this.selectedBorder : ColorMenu.this.unselectedBorder);
        }
    }
}

