/*
 * Decompiled with CFR 0.152.
 */
package org.mtk.arcade.billboard;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.mtk.arcade.billboard.BillboardLayer;
import org.mtk.arcade.billboard.ColorUtils;
import org.mtk.util.BitUtils;
import org.mtk.util.BitmapBuffer;
import org.mtk.util.ByteConverter;

public abstract class PolePositionBillboardLayer
extends BillboardLayer {
    BitmapBuffer largeSpriteBuffer;
    BitmapBuffer smallSpriteBuffer;
    BitmapBuffer buffer;
    Map<String, Color[]> paletteMap;
    static final int ROWS_PER_BOARD_HEIGHT = 2;
    static final int COLUMNS_PER_BOARD_WIDTH = 3;
    Color[] primaryPalette;
    Color[] secondaryPalette;
    int spriteSize;
    int imageOffset;
    String romloc;

    public PolePositionBillboardLayer(String romloc, int spritesize) {
        super(spritesize * 3, spritesize * 2);
        this.spriteSize = spritesize;
        this.romloc = romloc;
    }

    public void initPixels() {
        int x = 0;
        int y = 0;
        boolean done = false;
        int index = 0;
        byte[] bitmap = this.buffer.getBytes();
        while (!done) {
            while (x < this.w) {
                if (y >= this.h) {
                    done = true;
                    break;
                }
                byte b = bitmap[index++];
                byte c = bitmap[index++];
                int n = 4;
                for (int i = 0; i < n; ++i) {
                    Color pixel = this.makeColor(b, c, i, 0);
                    Color pixel2 = this.makeColor(b, c, i, 1);
                    this.color[x][y][0] = pixel;
                    this.color[x][y][1] = pixel2;
                    ++x;
                }
                if (bitmap.length != index && x <= this.w) continue;
                break;
            }
            x = 0;
            ++y;
            if (index < bitmap.length) continue;
            done = true;
        }
    }

    private Color makeColor(byte first, byte second, int i, int layer) {
        String s1 = ByteConverter.toBinary(first);
        String s2 = ByteConverter.toBinary(second);
        String substring = "" + s1.charAt(i) + s1.charAt(i + 4) + s2.charAt(i) + s2.charAt(i + 4);
        Color use = this.getColor(substring, layer);
        if (use == null) {
            System.out.println("No color mapping for " + substring);
        }
        return use;
    }

    private Color getColor(String substring, int layer) {
        Color c = null;
        if ("0000".equals(substring)) {
            c = Color.GRAY;
        } else if ("0001".equals(substring)) {
            c = Color.CYAN;
        } else if ("0010".equals(substring)) {
            c = ColorUtils.BLUE_GRAY;
        } else if ("0100".equals(substring)) {
            c = ColorUtils.PURPLE;
        }
        if (c != null) {
            return c;
        }
        Color[] colors = this.paletteMap.get(substring);
        if (colors == null) {
            return null;
        }
        return this.paletteMap.get(substring)[layer];
    }

    abstract void initPaletteMap();

    @Override
    public void setCoord(int x, int y, Color targetColor, int layer) {
        if (x >= 0 && x < this.getLayerWidth() && y >= 0 && y < this.getLayerHeight()) {
            Color otherLayerColor = this.getCoord(x, y, Math.abs(layer - 1));
            String byteStr = this.getTargetWordColor(targetColor, otherLayerColor, layer);
            if (byteStr == null) {
                return;
            }
            this.color[x][y][layer] = targetColor;
        }
    }

    private void setColorWordToBytes(int index, int offset, String byteStr, BitmapBuffer buffer) {
        for (int j = 0; j < 2; ++j) {
            byte orig = buffer.getByte(index + j);
            orig = byteStr.charAt(j * 2) == '0' ? BitUtils.clearBit(orig, 7 - offset) : BitUtils.setBit(orig, 7 - offset);
            orig = byteStr.charAt(1 + j * 2) == '0' ? BitUtils.clearBit(orig, 3 - offset) : BitUtils.setBit(orig, 3 - offset);
            buffer.setByte(index + j, orig);
        }
    }

    public String getTargetWordColor(Color targetColor, Color existingAltColor, int layer) {
        for (Map.Entry<String, Color[]> entry : this.paletteMap.entrySet()) {
            if (entry.getValue()[layer] != targetColor || entry.getValue()[Math.abs(layer - 1)] != existingAltColor) continue;
            return entry.getKey();
        }
        if (targetColor.equals(Color.GRAY) && existingAltColor.equals(Color.GRAY)) {
            return "0000";
        }
        if (targetColor.equals(Color.CYAN) && existingAltColor.equals(Color.CYAN)) {
            return "0001";
        }
        if (targetColor.equals(ColorUtils.BLUE_GRAY) && existingAltColor.equals(ColorUtils.BLUE_GRAY)) {
            return "0010";
        }
        if (targetColor.equals(ColorUtils.PURPLE) && existingAltColor.equals(ColorUtils.PURPLE)) {
            return "0100";
        }
        return null;
    }

    @Override
    public Color[] getColorPalette(int layer) {
        Color[] colors = layer != 0 ? this.secondaryPalette : this.primaryPalette;
        return colors;
    }

    @Override
    public Color getCoord(int x, int y, int layer) {
        return this.color[x][y][layer];
    }

    public void loadBinaryData() throws IOException {
        String firstRom = this.spriteSize == 16 ? this.getMiniFirstRom() : this.getFirstRom();
        String secondRom = this.spriteSize == 16 ? this.getMiniSecondRom() : this.getSecondRom();
        this.imageOffset = this.spriteSize == 16 ? this.getMiniOffset() : this.getOffset();
        BitmapBuffer b1 = BitmapBuffer.loadFile(this.romloc + File.separator + firstRom);
        BitmapBuffer b2 = BitmapBuffer.loadFile(this.romloc + File.separator + secondRom);
        this.largeSpriteBuffer = BitmapBuffer.weave(b1, b2, 1);
        if (this.spriteSize == 32) {
            b1 = BitmapBuffer.loadFile(this.romloc + File.separator + this.getMiniFirstRom());
            b2 = BitmapBuffer.loadFile(this.romloc + File.separator + this.getMiniSecondRom());
            this.smallSpriteBuffer = BitmapBuffer.weave(b1, b2, 1);
        }
        this.buffer = this.extractSprite(this.largeSpriteBuffer, this.spriteSize, this.imageOffset);
        this.initPaletteMap();
        this.initPixels();
    }

    private BitmapBuffer extractSprite(BitmapBuffer originalBuffer, int spriteSize, int imageOffset) {
        byte[] bytes = originalBuffer.getBytes();
        byte[] newBytes = new byte[bytes.length];
        int newByteIndex = 0;
        int bytesPerLine = spriteSize / 2;
        for (int n = 0; n < 2; ++n) {
            for (int m = 0; m < spriteSize; ++m) {
                for (int l = 0; l < 3; ++l) {
                    for (int j = 0; j < bytesPerLine; ++j) {
                        int bufferindex = imageOffset + j + bytesPerLine * (m + spriteSize * (l + n * 3));
                        if (newByteIndex >= 16384 || bufferindex >= 16384) {
                            System.out.println("oops " + (newByteIndex - 1) + " gets " + bufferindex);
                            continue;
                        }
                        newBytes[newByteIndex++] = bytes[bufferindex];
                    }
                }
            }
        }
        return new BitmapBuffer(newBytes);
    }

    protected abstract int getOffset();

    @Override
    public void save(String romloc) throws IOException {
        if (this.spriteSize == 32) {
            this.saveColorMatrixToBuffer(this.color, this.largeSpriteBuffer, this.getOffset(), this.spriteSize);
            System.out.println(this.largeSpriteBuffer.dumpHex(0, this.largeSpriteBuffer.getSize(), 8, true));
            BitmapBuffer largePart1 = new BitmapBuffer();
            BitmapBuffer largePart2 = new BitmapBuffer();
            BitmapBuffer.unweave(this.largeSpriteBuffer, largePart1, largePart2, 1);
            Color[][][] smallImage = new Color[this.w / 2][this.h / 2][2];
            for (int k = 0; k < 2; ++k) {
                for (int y = 0; y < this.h / 2; ++y) {
                    for (int x = 0; x < this.w / 2; ++x) {
                        smallImage[x][y][k] = this.getCoord(x * 2 + 1, y * 2 + 1, k);
                    }
                }
            }
            BitmapBuffer.writeFile(largePart1, romloc + File.separator + this.getFirstRom() + "_new");
            BitmapBuffer.writeFile(largePart2, romloc + File.separator + this.getSecondRom() + "_new");
            this.saveColorMatrixToBuffer(smallImage, this.smallSpriteBuffer, this.getMiniOffset(), 16);
        } else {
            Color[][][] smallImage = this.color;
            this.saveColorMatrixToBuffer(smallImage, this.largeSpriteBuffer, this.getMiniOffset(), this.spriteSize);
            this.smallSpriteBuffer = this.largeSpriteBuffer;
        }
        BitmapBuffer smallPart1 = new BitmapBuffer();
        BitmapBuffer smallPart2 = new BitmapBuffer();
        BitmapBuffer.unweave(this.smallSpriteBuffer, smallPart1, smallPart2, 1);
        BitmapBuffer.writeFile(smallPart1, romloc + File.separator + this.getMiniFirstRom() + "_new");
        BitmapBuffer.writeFile(smallPart2, romloc + File.separator + this.getMiniSecondRom() + "_new");
    }

    private void saveColorMatrixToBuffer(Color[][][] smallImage, BitmapBuffer targetBuffer, int imageOffset, int spriteSize) {
        int size = targetBuffer.getSize();
        BitmapBuffer smallWorkingBuffer = new BitmapBuffer(new byte[size]);
        for (int x = 0; x < 3 * spriteSize; ++x) {
            for (int y = 0; y < 2 * spriteSize; ++y) {
                Color primary = smallImage[x][y][0];
                Color secondary = smallImage[x][y][1];
                String byteStr = this.getTargetWordColor(primary, secondary, 0);
                int pixelsByRowY = y * (3 * spriteSize);
                int index = (pixelsByRowY + x) / 4 * 2;
                int bitOffset = x % 4;
                this.setColorWordToBytes(index, bitOffset, byteStr, smallWorkingBuffer);
            }
        }
        this.insertSprite(smallWorkingBuffer, targetBuffer, imageOffset, spriteSize);
    }

    private void insertSprite(BitmapBuffer source, BitmapBuffer target, int imageOffset, int spriteSize) {
        byte[] newBytes = source.getBytes();
        int newByteIndex = 0;
        int bytesPerLine = spriteSize / 2;
        for (int n = 0; n < 2; ++n) {
            for (int m = 0; m < spriteSize; ++m) {
                for (int l = 0; l < 3; ++l) {
                    for (int j = 0; j < bytesPerLine; ++j) {
                        int bufferindex = imageOffset + j + bytesPerLine * (m + spriteSize * (l + n * 3));
                        target.setByte(bufferindex, newBytes[newByteIndex++]);
                    }
                }
            }
        }
    }

    abstract String getFirstRom();

    abstract String getSecondRom();

    protected abstract int getMiniOffset();

    abstract String getMiniFirstRom();

    abstract String getMiniSecondRom();

    public static Color findNearestColor(Color[] palette, Color targetColor) {
        Color nearestColor = palette[0];
        double minDistance = Double.MAX_VALUE;
        for (Color paletteColor : palette) {
            double distance = PolePositionBillboardLayer.colorDistance(targetColor, paletteColor);
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            nearestColor = paletteColor;
        }
        return nearestColor;
    }

    public static double colorDistance(Color c1, Color c2) {
        double redDiff = c1.getRed() - c2.getRed();
        double greenDiff = c1.getGreen() - c2.getGreen();
        double blueDiff = c1.getBlue() - c2.getBlue();
        return Math.sqrt(redDiff * redDiff + greenDiff * greenDiff + blueDiff * blueDiff);
    }

    @Override
    public void importImage(BufferedImage image, int layer) {
        int width = image.getWidth();
        int height = image.getHeight();
        int exactWidth = this.spriteSize * 3;
        int exactHeight = this.spriteSize * 2;
        if (width != exactWidth || height != exactHeight) {
            throw new IllegalArgumentException("Image must be " + exactWidth + " pixels wide and " + exactHeight + " pixels high.");
        }
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Color pixelColor = new Color(image.getRGB(x, y));
                Color finalColor = PolePositionBillboardLayer.findNearestColor(layer == 0 ? this.primaryPalette : this.secondaryPalette, pixelColor);
                this.setCoord(x, y, finalColor, layer);
            }
        }
    }

    @Override
    public BufferedImage convertToBufferedImage(int layer) {
        BufferedImage image = new BufferedImage(3 * this.spriteSize, 2 * this.spriteSize, 1);
        for (int x = 0; x < 3 * this.spriteSize; ++x) {
            for (int y = 0; y < 2 * this.spriteSize; ++y) {
                image.setRGB(x, y, this.color[x][y][layer].getRGB());
            }
        }
        return image;
    }
}

