/*
 * Decompiled with CFR 0.152.
 */
package org.mtk.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.mtk.util.ByteConverter;

public class BitmapBuffer {
    byte[] bitmap;

    public BitmapBuffer() {
        this.bitmap = new byte[0];
    }

    public BitmapBuffer(byte[] b) {
        this.bitmap = b;
    }

    public static void writeFile(BitmapBuffer buffer, String s) throws IOException {
        File outputFile = new File(s);
        if (outputFile.exists()) {
            throw new IllegalArgumentException("File exists");
        }
        if (!outputFile.createNewFile()) {
            throw new IllegalArgumentException("File exists");
        }
        try (FileOutputStream outputStream = new FileOutputStream(outputFile);){
            outputStream.write(buffer.getBytes());
        }
    }

    public void setBit(int offset, int i, boolean tf) {
        this.bitmap[offset] = tf ? (byte)(this.bitmap[offset] | (byte)Math.pow(2.0, i % 8)) : (byte)(this.bitmap[offset] ^ (byte)Math.pow(2.0, i % 8));
    }

    public boolean getBit(int offset, int i) {
        return (this.bitmap[offset] >> i & 1) == 1;
    }

    public byte[] getBytes(int offset, int buffersize) {
        byte[] temp = new byte[buffersize];
        System.arraycopy(this.bitmap, offset, temp, 0, buffersize);
        return temp;
    }

    public byte[] getBytes(int offset) {
        byte[] temp = new byte[this.bitmap.length - offset];
        System.arraycopy(this.bitmap, offset, temp, 0, temp.length);
        return temp;
    }

    public byte[] getBytes() {
        return this.bitmap;
    }

    public static BitmapBuffer loadFile(String string) throws IOException {
        File f = new File(string);
        return BitmapBuffer.loadFile(f);
    }

    public static BitmapBuffer loadFile(File f) throws IOException {
        byte[] get = new byte[(int)f.length()];
        FileInputStream fis = new FileInputStream(f);
        fis.read(get);
        fis.close();
        BitmapBuffer buffer = new BitmapBuffer();
        buffer.setContents(get);
        return buffer;
    }

    private void setContents(byte[] get) {
        this.bitmap = get;
    }

    public int getSize() {
        return this.bitmap.length;
    }

    public String dumpBinary(int start, int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = start; i < length; ++i) {
            sb.append(i).append(": ");
            for (int j = 7; j >= 0; --j) {
                boolean bitOn;
                boolean bl = bitOn = (this.bitmap[i] >> j & 1) == 1;
                if (bitOn) {
                    sb.append("1");
                    continue;
                }
                sb.append("0");
            }
        }
        return sb.toString();
    }

    public String dumpHex() {
        return this.dumpHex(0, this.getSize(), 8, false);
    }

    public String dumpHex(int start, int length, int width, boolean showAddress) {
        StringBuilder sb = new StringBuilder();
        boolean done = false;
        int index = 0;
        int linelength = 0;
        int linecount = 0;
        while (!done) {
            if (showAddress) {
                String num = "0000" + Integer.toHexString(linecount);
                sb.append(num.substring(num.length() - 4)).append(": ");
            }
            while (linelength < width) {
                sb.append(ByteConverter.toHex(this.bitmap[index]));
                if (this.bitmap.length != ++index && ++linelength <= width) continue;
            }
            sb.append("\n");
            linelength = 0;
            linecount += width;
            if (index < this.bitmap.length) continue;
            done = true;
        }
        return sb.toString();
    }

    public static BitmapBuffer weave(BitmapBuffer b1, BitmapBuffer b2, int size) {
        assert (b1.getSize() == b2.getSize());
        byte[] comp = new byte[b1.getSize() + b2.getSize()];
        byte[] bytes1 = b1.getBytes();
        byte[] bytes2 = b2.getBytes();
        int index = 0;
        int n = bytes1.length / size;
        for (int i = 0; i < n; ++i) {
            int j;
            for (j = 0; j < size; ++j) {
                comp[index++] = bytes1[i];
            }
            for (j = 0; j < size; ++j) {
                comp[index++] = bytes2[i];
            }
        }
        return new BitmapBuffer(comp);
    }

    public byte getByte(int offset) {
        return this.bitmap[offset];
    }

    public void setByte(int offset, byte b) {
        this.bitmap[offset] = b;
    }

    public static void unweave(BitmapBuffer input, BitmapBuffer part1, BitmapBuffer part2, int skipbytes) {
        int size = input.getSize();
        part1.setContents(new byte[size / 2]);
        part2.setContents(new byte[size / 2]);
        int index = 0;
        int half1index = 0;
        int half2index = 0;
        while (index < size) {
            int bytes;
            for (bytes = 0; bytes < skipbytes; ++bytes) {
                part1.setByte(half1index++, input.getByte(index++));
            }
            for (bytes = 0; bytes < skipbytes; ++bytes) {
                part2.setByte(half2index++, input.getByte(index++));
            }
        }
    }

    public static BitmapBuffer join(BitmapBuffer firsthalf, BitmapBuffer secondhalf, int bytelength) {
        byte[] lbytes = firsthalf.getBytes();
        byte[] rbytes = secondhalf.getBytes();
        byte[] totalbytes = new byte[rbytes.length + lbytes.length];
        int index = 0;
        int lcount = 0;
        int rcount = 0;
        boolean done = false;
        while (!done) {
            int i;
            for (i = 0; i < bytelength; ++i) {
                totalbytes[index] = lbytes[lcount];
                ++index;
                ++lcount;
            }
            for (i = 0; i < bytelength; ++i) {
                totalbytes[index] = rbytes[rcount];
                ++index;
                ++rcount;
            }
            if (lbytes.length * 2 != index) continue;
            done = true;
        }
        return new BitmapBuffer(totalbytes);
    }

    public byte getChecksum() {
        byte b = 0;
        for (byte value : this.bitmap) {
            b = (byte)(b + value);
        }
        return b;
    }
}

